#include <gst/gst.h>
#import "EaglUIVIew.h"

@interface GStreamerBackend : NSObject
{
    GstElement *_pipeline;
    GMainContext *_context;
    GMainLoop *_mainLoop;
    BOOL _isActive;
}

@property (weak, nonatomic, readonly) id delegate;
@property (nonatomic, strong, readonly) NSString* streamId;
@property (nonatomic, strong, readonly) EaglUIView *displayView;
@property (nonatomic, readonly) BOOL isActive;
@property (nonatomic) CGPoint firstTouchPosition;
@property (nonatomic) CGPoint displayCenterAtFirstTouch;

-(id) initWithDelegate:(id)delegate streamId:(NSString *)streamId displayView:(EaglUIView *)displayView;
-(void) start;
-(void) stop;
-(NSString *) getGStreamerVersion;

// these bridge between c land and objective-c
-(void) gstLeaveMainLoop;
-(void) gstElementMessage:(GstBus *)bus message:(GstMessage *)msg;
-(void) gstPipelineStateChanged:(GstState)oldState newState:(GstState)newState pendingState:(GstState)pendingState;
-(BOOL) objectIsPipeline:(GstObject *)object;

@end